/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/hiddev.h>
#include <time.h>
#include <linux/input.h>

#include <linux/ioctl.h>
#include "iowarrior.h"


int main( int argc, char **argv )
{

	int fd1 = -1;
//	int fd2 = -1;


	if(( fd1 = open( "/dev/usb/iowarrior1", O_RDWR )) < 0 )
	{
		perror( "iowarrior1 open" );
		exit( 1 );
	}
/*
	// If there are more IO-Warriors
	if(( fd2 = open( "/dev/usb/iowarrior3", O_RDWR)) < 0 )
	{
		perror( "iowarrior3 open" );
		exit( 1 );
	}
	// and so on ...
*/
	#define BUFFER_SIZE 8
	unsigned char out_buffer[BUFFER_SIZE];
	unsigned char  in_buffer[BUFFER_SIZE+1];	// for serial number
	int retval;

	long time_1, time_2;
	long * pTime_1 = &time_1;

	time( pTime_1 );
	time_2 = time_1 + 60;

	out_buffer[0] = 0x0C;			/* Report ID for RC5 IR function */
	out_buffer[1] = 0x01;			/* enable RC5 IR function */
	out_buffer[2] = 0x00;
	out_buffer[3] = 0x00;
	out_buffer[4] = 0x00;
	out_buffer[5] = 0x00;
	out_buffer[6] = 0x00;
	out_buffer[7] = 0x00;

	if( ioctl( fd1, IOW_WRITE, out_buffer ))
	{
		perror( "iowarrior1 ioctl" );
		goto end;
	}

	retval = read( fd1, in_buffer, BUFFER_SIZE+1 );
	if( retval == -1 )
	{
		perror( "iowarrior1 read" );
		goto end;
	}
	printf( "%02x - %02x %02x %02x %02x %02x %02x %02x %02x\n",
	        in_buffer[BUFFER_SIZE],
			in_buffer[0],
			in_buffer[1],
			in_buffer[2],
			in_buffer[3],
			in_buffer[4],
			in_buffer[5],
			in_buffer[6],
			in_buffer[7] );

	while( time_1 < time_2 )
	{
		retval = read( fd1, in_buffer, BUFFER_SIZE );
		if( retval == -1 )
		{
			perror( "iowarrior1 read" );
			goto end;
		}
	printf( "%02x - %02x %02x %02x %02x %02x %02x %02x %02x\n",
	        in_buffer[BUFFER_SIZE],
			in_buffer[0],
			in_buffer[1],
			in_buffer[2],
			in_buffer[3],
			in_buffer[4],
			in_buffer[5],
			in_buffer[6],
			in_buffer[7] );

		time( pTime_1 );
	}

end:
	out_buffer[1] = 0x00;
	ioctl( fd1, IOW_WRITE, out_buffer );
	close( fd1 );
//	close( fd2 );
	exit( 0 );
}
